#
# alcune considerazioni sul coefficiente di correlazione lineare
#
#

x <- c(1:10)

m <- c(-100,-10,-1,0,1,10,100)
q <- c(3)


y1 = m[1] * x + q
y2 = m[2] * x + q
y3 = m[3] * x + q
y4 = m[4] * x + q
y5 = m[5] * x + q
y6 = m[6] * x + q
y7 = m[7] * x + q

# se grafichiamo y in funzione di x notiamo che i punti sono perfettamente 
# allineati, ovvio per come gli abbiamo costruiti

plot(x,y1, type = "l", ylim = c(-1000,1000))
points(x,y2, type = "l")
points(x,y3, type = "l")
points(x,y4, type = "l")
points(x,y5, type = "l")
points(x,y6, type = "l")
points(x,y7, type = "l")

ErrSim <- rnorm(10, 0, 0.5)

ymis1 = y1+ErrSim
ymis2 = y2+ErrSim
ymis3 = y3+ErrSim
ymis4 = y4+ErrSim
ymis5 = y5+ErrSim
ymis6 = y6+ErrSim
ymis7 = y7+ErrSim

r1 = sum((x-mean(x))*(ymis1-mean(ymis1)))/sqrt(sum((x-mean(x))^2)*sum((ymis1-mean(ymis1))^2))
r2 = sum((x-mean(x))*(ymis2-mean(ymis2)))/sqrt(sum((x-mean(x))^2)*sum((ymis2-mean(ymis2))^2))
r3 = sum((x-mean(x))*(ymis3-mean(ymis3)))/sqrt(sum((x-mean(x))^2)*sum((ymis3-mean(ymis3))^2))
r4 = sum((x-mean(x))*(ymis4-mean(ymis4)))/sqrt(sum((x-mean(x))^2)*sum((ymis4-mean(ymis4))^2))
r5 = sum((x-mean(x))*(ymis5-mean(ymis5)))/sqrt(sum((x-mean(x))^2)*sum((ymis5-mean(ymis5))^2))
r6 = sum((x-mean(x))*(ymis6-mean(ymis6)))/sqrt(sum((x-mean(x))^2)*sum((ymis6-mean(ymis6))^2))
r7 = sum((x-mean(x))*(ymis7-mean(ymis7)))/sqrt(sum((x-mean(x))^2)*sum((ymis7-mean(ymis7))^2))



###### proviamo con una dispersione grande

ErrSimBis <- rnorm(10, 0, 4)

ymis5Bis = y5 + ErrSimBis

plot(x, ymis5Bis, pch = 16, col = 2)
points(x, ymis5, pch = 16)

r5bis = sum((x-mean(x))*(ymis5Bis-mean(ymis5Bis)))/sqrt(sum((x-mean(x))^2)*sum((ymis5Bis-mean(ymis5Bis))^2))


fit5 <- lm(ymis5 ~ x)
fit5bis <- lm(ymis5Bis ~ x)

curve(coef(fit5)[2]*x+coef(fit5)[1], add=T)
curve(coef(fit5bis)[2]*x+coef(fit5bis)[1], add=T, col = 2)




########################
###### alcune considerazioni sul chi2


x <- c(1:10)

m = 2
q = 3

sigma <- c(0.25,0.5,0.75,1,1.25,1.5,1.75)

chi2rid = 0

 N = 20


for (j in 1:length(sigma)) {

    xmis = 0
    y = 0

    for (i in 1:10) {
        xmis[((i-1)*N+1):(i*N)] = rep(x[i],N)
        y[((i-1)*N+1):(i*N)] = rnorm(N, m*x[i]+q, sigma[j])
    }

    chi2rid[j] = (summary(lm(y ~ xmis))$sigma)^2

}











###### ri
summary(fitlm)

plot(x,ymis)
curve(coef(fitlm)[2]*x+coef(fitlm)[1], add=T, col = 2)


############# fit linear model pesi


symis = abs(ErrSim)

w= 1/symis^2

library(sfsmisc)


errbar(x,ymis,ymis+symis,ymis-symis, pch = 16)


fitlmW <- lm(ymis ~ x, weights = w)


curve(coef(fitlmW)[2]*x+coef(fitlmW)[1], add=T, col = 2)
curve(coef(fitlm)[2]*x+coef(fitlm)[1], add=T, col = 4)




################ fine lezione R 24/11/2014












data <- data.frame(x,ymis,symis)

##write.table(data,"./dati.dat")
write.table(data,"~/Documents/Didattica/2014 2015/LaboratorioLuppi/esercitazione R/Lezione_R_24112014/dati.dat")


## facciamo il grafico con le barre d'errore
## per caricare le barre d'errore bisogna richiamare il pacchetto sfsmisc (per le vecchie versioni di R si usava Hmisc)
## per installare il pacchetto fare:
## install.packages("sfsmisc")  e seguire le istruzioni

##newdata <- read.table("./dati.dat")
newdata <- read.table("~/Documents/Didattica/2014 2015/LaboratorioLuppi/esercitazione R/Lezione_R_24112014/dati.dat")

x = newdata$x
ymis = newdata$ymis
symis = newdata$symis

library(sfsmisc)

## se non riesce a caricare il pacchetto alloa bisogna scaricarlo, installarlo e ricaricarlo.
## per scaricare e installare si fa in automatico dal menu' pacchetti -> installa pacchetti, 
## si selezione il pacchetto desiderato e verra scaricato e installato.

errbar(x,ymis,ymis+symis,ymis-symis, pch = 16)


# eseguiamo il fit non pesato
##### questo comando va usato se x e y non sono stati usati come nomi per le variabili.
##### datifit2 <- lm(y ~ x, data=datimis)

fitlm <- lm(ymis ~ x)

errbar(x,ymis,ymis+symis,ymis-symis, pch = 16)
curve(coef(fitlm)[2]*x+coef(fitlm)[1], add=T, col = 2)


# controlliamo i coefficienti calcolati

summary(fitlm)


############ calcoliamo il chi2 ridotto
### costriamo le y fittate

yfit = coef(fitlm)[2]*x + coef(fitlm)[1]

### calcoliamo chi2

chi2 = sum(w*(ymis - yfit)^2)

## calcoliamo chi2 ridotto

chi2rid =  sum(w*(ymis - yfit)^2)/8

## verifichiamo che  uguale al residual standard error

sqrt(chi2rid)


############# calcoliamo il coefficiente di correlazione lineare












# eseguiamo il fit pesato
##### questo comando va usato se x e y non sono stati usati come nomi per le variabili.
##### datifit2 <- lm(y ~ x, data=datimis)

fitlm <- lm(ymis ~ x, weights=w)

errbar(x,ymis,ymis+symis,ymis-symis, pch = 16)
curve(coef(fitlm)[2]*x+coef(fitlm)[1], add=T, col = 2)


# controlliamo i coefficienti calcolati

summary(fitlm)


############ calcoliamo il chi2 ridotto
### costriamo le y fittate

yfit = coef(fitlm)[2]*x + coef(fitlm)[1]




















############################################
# 
# un metodo pi generale, nel quale la funzione da utilizzare e i 
# parametri vengono impstati dall'utente  l'uso del comando
# nls()
# questo metodo  pi adatto quando gli andamenti non sono lineari, 
# ma proviamolo ugualmente anche per questo
#
# nella formula dobbiano definire i parametri, inoltre dobbiamo suggerire 
# dei valori di partenza per questi.
#

fitnls <- nls(ymis ~ Amis * x + Bmis, start = list(Amis = 1, Bmis = 1), weights=w)

# visualizziamo i risultati ottenuti

summary(fitnls)


### costriamo le y fittate

yfit = coef(fitnls)[1]*x + coef(fitnls)[2]



### calcoliamo chi2

chi2 = sum(w*(ymis - yfit)^2)

## calcoliamo chi2 ridotto

chi2rid =  sum(w*(ymis - yfit)^2)/8

## verifichiamo che  uguale al residual standard error

sqrt(chi2rid)

### visualizziamo singolarmente RSE con 

summary(fitnls)$sigma

### visualizziamo singolarmente il numero di gradi di libert

summary(fitnls)$df[2]

##### determiniamo la probabilita di avere un chi quadro maggiore 
# usando tutte le informazioni del fit:


pchisq(((summary(fitnls)$sigma)^2)*summary(fitnls)$df[2], summary(fitnls)$df[2], lower.tail=F)


## visualizziamo il grafico

plot(x,ymis)
errbar(x,ymis,ymis+symis,ymis-symis, add=T)
curve(coef(fitnls)[1]*x+coef(fitnls)[2], add=T)



#############################################

# proviamo con altro esempio, questa volta 
# ipotizziamo un andamento esponenziale decrescente
# y = A2teo * exp(-B2teo*x) + C2teo

A2teo = 5
B2teo = 0.3
C2teo = 0

y2= A2teo * exp(-B2teo*x) + C2teo

ErrSim2 <- rnorm(10, 0, 0.2)

w2 = 1/ErrSim2^2

y2mis = y2 + ErrSim2

datifit <- nls(y2mis ~ A2mis * exp(-B2mis*x) + C2mis, start = list(A2mis = 1, B2mis = 0.1, C2mis=0.1), weights=w2)

plot(x,y2mis)
lines(x, predict(datifit), col=2)

######################
# un altro modo per visualizzare dati e funzione fittata  questo

plot(x,y2mis)
errbar(x,y2mis,y2mis+abs(ErrSim2),y2mis-abs(ErrSim2), add=T)
curve(coef(datifit)[1] * exp(-coef(datifit)[2]*x) + coef(datifit)[3], add=T)

summary(datifit)

pchisq(((summary(datifit)$sigma)^2)*summary(datifit)$df[2], summary(datifit)$df[2], lower.tail=F)



